//==>WiZaRd/Max AutoHardLimit [cyrex2001]
// PPgConnection2.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "emule.h"
#include "PPgConnection2.h"
#include "emuledlg.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "preferencesdlg.h"


// CPPgConnection2-Dialogfeld

IMPLEMENT_DYNAMIC(CPPgConnection2, CPropertyPage)
CPPgConnection2::CPPgConnection2()
	: CPropertyPage(CPPgConnection2::IDD)
{
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("CONNECTION")));
	m_imageList.Add(CTempIconLoader(_T("HARDLIMIT")));
	m_imageList.Add(CTempIconLoader(_T("CONNECTION")));
}

CPPgConnection2::~CPPgConnection2()
{
}

void CPPgConnection2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_CON2, m_tabCtr);

	DDX_Control(pDX, IDC_AHL_MAXSRC, m_ctlAHLMaxSrc);
	DDX_Control(pDX, IDC_AHL_MAXSRCF, m_ctlAHLMaxSrcF);
	DDX_Control(pDX, IDC_AHL_MINSRCF, m_ctlAHLMinSrcF);
	DDX_Control(pDX, IDC_AHL_TIMER, m_ctlAHLTimer);

	DDX_Control(pDX, IDC_CON2_HL, m_ctlHLSources);
}


BEGIN_MESSAGE_MAP(CPPgConnection2, CPropertyPage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_CON2, OnTcnSelchangeTabConnection2)

	ON_EN_KILLFOCUS(IDC_AHL_MAXSRC, OnSettingsChange)
	ON_EN_KILLFOCUS(IDC_AHL_MAXSRCF, OnSettingsChange)
	ON_EN_KILLFOCUS(IDC_AHL_MINSRCF, OnSettingsChange)
	ON_EN_KILLFOCUS(IDC_AHL_TIMER, OnSettingsChange)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_AHL_OFF, OnBnClickedAutoHL)
	ON_BN_CLICKED(IDC_AHL_ON, OnBnClickedAutoHL)
	ON_BN_CLICKED(IDC_AHL_FILE, OnBnClickedAutoHL)

	ON_EN_KILLFOCUS(IDC_CON2_HL, OnSettingsChange)
END_MESSAGE_MAP()


// CPPgConnection2-Meldungshandler

BOOL CPPgConnection2::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitTab(true,1);
	m_tabCtr.SetCurSel(theApp.emuledlg->preferenceswnd->StartPageConnection);
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE; 
}

void CPPgConnection2::Localize(void)
{
	if(m_hWnd)
	{

		GetDlgItem(IDC_AHL_GBOX)->SetWindowText(GetResString(IDS_AHL_GBOX));
		GetDlgItem(IDC_AHL_OFF)->SetWindowText(GetResString(IDS_AHL_OFF));
		GetDlgItem(IDC_AHL_ON)->SetWindowText(GetResString(IDS_AHL_ON));
		GetDlgItem(IDC_AHL_FILE)->SetWindowText(GetResString(IDS_AHL_FILE));
		GetDlgItem(IDC_AHL_MAXSRC_LBL1)->SetWindowText(GetResString(IDS_AHL_MAXSRC));
		GetDlgItem(IDC_AHL_MAXSRCF_LBL1)->SetWindowText(GetResString(IDS_AHL_MAXSRCF));
		GetDlgItem(IDC_AHL_MINSRCF_LBL1)->SetWindowText(GetResString(IDS_AHL_MINSRCF));
		GetDlgItem(IDC_AHL_TIMER_LBL1)->SetWindowText(GetResString(IDS_AHL_TIMER));

		GetDlgItem(IDC_CON2_HLBOX)->SetWindowText(GetResString(IDS_CON2_HLBOX));
		if(thePrefs.IsUseAutoHL() == 0)
			GetDlgItem(IDC_CON2_HL_LBL1)->SetWindowText(GetResString(IDS_CON2_HL_LBLN));
		else
			GetDlgItem(IDC_CON2_HL_LBL1)->SetWindowText(GetResString(IDS_CON2_HL_LBLA));
	}
}

void CPPgConnection2::LoadSettings(void)
{

	int toAdd = thePrefs.IsUseAutoHL();
		if(toAdd == 0)
			toAdd = 0;
		else if(toAdd == 1)
			toAdd = 1;
		else if(toAdd == -1)
			toAdd = 2;
		else
			toAdd = 0;
	CheckRadioButton(IDC_AHL_OFF,IDC_AHL_FILE,IDC_AHL_OFF + toAdd);

	CString strBuffer;

	m_ctlAHLMaxSrc.SetRange(1000, 7500);
	m_ctlAHLMaxSrc.SetPos(thePrefs.GetMaxSourcesHL());
	m_ctlAHLMaxSrc.SetTicFreq(100);

	strBuffer.Format(_T("%d"), m_ctlAHLMaxSrc.GetPos());
	GetDlgItem(IDC_AHL_MAXSRC_LBL2)->SetWindowText(strBuffer);

	m_ctlAHLMaxSrcF.SetRange(100, 1500);
	m_ctlAHLMaxSrcF.SetPos(thePrefs.GetMaxAutoHL());
	m_ctlAHLMaxSrcF.SetTicFreq(100);

	strBuffer.Format(_T("%d"), m_ctlAHLMaxSrcF.GetPos());
	GetDlgItem(IDC_AHL_MAXSRCF_LBL2)->SetWindowText(strBuffer);

	m_ctlAHLMinSrcF.SetRange(10, 50);
	m_ctlAHLMinSrcF.SetPos(thePrefs.GetMinAutoHL());
	m_ctlAHLMinSrcF.SetTicFreq(5);

	strBuffer.Format(_T("%d"), m_ctlAHLMinSrcF.GetPos());
	GetDlgItem(IDC_AHL_MINSRCF_LBL2)->SetWindowText(strBuffer);

	m_ctlAHLTimer.SetRange(10, 600);
	m_ctlAHLTimer.SetPos(thePrefs.GetAutoHLUpdateTimer());
	m_ctlAHLTimer.SetTicFreq(10);

	strBuffer.Format(_T("%d"), m_ctlAHLTimer.GetPos());
	GetDlgItem(IDC_AHL_TIMER_LBL2)->SetWindowText(strBuffer);

	if(IsDlgButtonChecked(IDC_AHL_OFF))
	{
		GetDlgItem(IDC_AHL_MAXSRC_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRC_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRC)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRCF_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRCF_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRCF)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MINSRCF_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MINSRCF_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MINSRCF)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_TIMER_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_TIMER_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_TIMER)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_AHL_MAXSRC_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRC_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRC)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRCF_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRCF_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRCF)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MINSRCF_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MINSRCF_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MINSRCF)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_TIMER_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_TIMER_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_TIMER)->EnableWindow(TRUE);
	}


	m_ctlHLSources.SetRange(0, 1500);
	m_ctlHLSources.SetTicFreq(50);
	if (thePrefs.maxsourceperfile == 0xFFFF)
		m_ctlHLSources.SetPos(0);
	else{
		m_ctlHLSources.SetPos(thePrefs.maxsourceperfile);
	}

	strBuffer.Format(_T("%d"), m_ctlHLSources.GetPos());
	GetDlgItem(IDC_CON2_HL_LBL2)->SetWindowText(strBuffer);
}

BOOL CPPgConnection2::OnApply()
{
	if(IsDlgButtonChecked(IDC_AHL_OFF))
		thePrefs.SetUseAutoHL(0);
	else if(IsDlgButtonChecked(IDC_AHL_ON))
		thePrefs.SetUseAutoHL(1);
	else
		thePrefs.SetUseAutoHL(-1);

	thePrefs.SetMaxSourcesHL((uint16)m_ctlAHLMaxSrc.GetPos());
	thePrefs.SetMaxAutoHL((uint16)m_ctlAHLMaxSrcF.GetPos());
	thePrefs.SetMinAutoHL((uint16)m_ctlAHLMinSrcF.GetPos());
	thePrefs.SetAutoHLUpdateTimer((uint16)m_ctlAHLTimer.GetPos());
	thePrefs.maxsourceperfile = ((uint16)m_ctlHLSources.GetPos());


	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgConnection2::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection1, GetResString(IDS_CON1_NAME), 0, (LPARAM)Connection1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection2, GetResString(IDS_CON2_NAME), 1, (LPARAM)Connection2); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection3, GetResString(IDS_CON3_NAME), 2, (LPARAM)Connection3); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgConnection2::OnTcnSelchangeTabConnection2(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}

void CPPgConnection2::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CString strBuffer;
	if (pScrollBar == GetDlgItem(IDC_AHL_MAXSRC))
	{
		strBuffer.Format(_T("%d"), m_ctlAHLMaxSrc.GetPos());
		GetDlgItem(IDC_AHL_MAXSRC_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
	if (pScrollBar == GetDlgItem(IDC_AHL_MAXSRCF))
	{
		strBuffer.Format(_T("%d"), m_ctlAHLMaxSrcF.GetPos());
		GetDlgItem(IDC_AHL_MAXSRCF_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
	if (pScrollBar == GetDlgItem(IDC_AHL_MINSRCF))
	{
		strBuffer.Format(_T("%d"), m_ctlAHLMinSrcF.GetPos());
		GetDlgItem(IDC_AHL_MINSRCF_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
	if (pScrollBar == GetDlgItem(IDC_AHL_TIMER))
	{
		strBuffer.Format(_T("%d"), m_ctlAHLTimer.GetPos());
		GetDlgItem(IDC_AHL_TIMER_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}

	if (pScrollBar == GetDlgItem(IDC_CON2_HL))
	{
		strBuffer.Format(_T("%d"), m_ctlHLSources.GetPos());
		GetDlgItem(IDC_CON2_HL_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}

	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CPPgConnection2::OnBnClickedAutoHL()
{
	if(IsDlgButtonChecked(IDC_AHL_OFF))
	{
		GetDlgItem(IDC_AHL_MAXSRC_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRC_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRC)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRCF_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRCF_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MAXSRCF)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MINSRCF_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MINSRCF_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_MINSRCF)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_TIMER_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_TIMER_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AHL_TIMER)->EnableWindow(FALSE);
		GetDlgItem(IDC_CON2_HL_LBL1)->SetWindowText(GetResString(IDS_CON2_HL_LBLN));
	}
	else
	{
		GetDlgItem(IDC_AHL_MAXSRC_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRC_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRC)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRCF_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRCF_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MAXSRCF)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MINSRCF_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MINSRCF_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_MINSRCF)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_TIMER_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_TIMER_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AHL_TIMER)->EnableWindow(TRUE);
		GetDlgItem(IDC_CON2_HL_LBL1)->SetWindowText(GetResString(IDS_CON2_HL_LBLA));
	}
	SetModified();
}